import { type Metadata } from "next";
import { BlogCard } from "@/components/blog-card";
import fetchContentType from "@/lib/strapi/fetchContentType";
import { generateMetadataObject } from "@/lib/shared/metadata";

export async function generateMetadata({
  params,
}: {
  params: { locale: string };
}): Promise<Metadata> {
  const pageData = await fetchContentType(
    "blog-page",
    {
      filters: { locale: params.locale },
      populate: "seo.metaImage",
    },
    true
  );

  const seo = pageData?.seo;
  const metadata = generateMetadataObject(seo);
  return metadata;
}

export default async function Blog({
  params,
}: {
  params: { locale: string; slug: string };
}) {
  const blogPage = await fetchContentType(
    "blog-page",
    {
      filters: { locale: params.locale },
    },
    true
  );
  const articles = await fetchContentType(
    "articles",
    {
      filters: { locale: params.locale },
    },
    false
  );

  const localizedSlugs = blogPage.localizations?.reduce(
    (acc: Record<string, string>, localization: any) => {
      acc[localization.locale] = "blog";
      return acc;
    },
    { [params.locale]: "blog" }
  );

  return (
    <div className="relative overflow-hidden py-20 md:py-0">
      {articles.data.slice(0, 1).map((article: any) => (
        <BlogCard
          article={article}
          locale={params.locale}
          key={article.title}
        />
      ))}
    </div>
  );
}

