import type { Schema, Struct } from '@strapi/strapi';

export interface CardsGlobeCard extends Struct.ComponentSchema {
  collectionName: 'components_cards_globe_cards';
  info: {
    description: '';
    displayName: 'Globe_Card';
    icon: 'dashboard';
  };
  attributes: {
    description: Schema.Attribute.String;
    span: Schema.Attribute.Enumeration<['one', 'two', 'three']>;
    title: Schema.Attribute.String;
  };
}

export interface CardsGraphCard extends Struct.ComponentSchema {
  collectionName: 'components_cards_graph_cards';
  info: {
    description: '';
    displayName: 'Graph_Card';
    icon: 'dashboard';
  };
  attributes: {
    description: Schema.Attribute.String;
    highlighted_text: Schema.Attribute.String;
    span: Schema.Attribute.Enumeration<['one', 'two', 'three']>;
    title: Schema.Attribute.String;
    top_items: Schema.Attribute.Component<'items.graph-card-top-items', true>;
  };
}

export interface CardsMemberCard extends Struct.ComponentSchema {
  collectionName: 'components_cards_member_cards';
  info: {
    displayName: 'Member_Card';
  };
  attributes: {
    association: Schema.Attribute.String;
    image: Schema.Attribute.Media<'images' | 'files'>;
    name: Schema.Attribute.String;
    role: Schema.Attribute.String;
    type: Schema.Attribute.String;
  };
}

export interface CardsPhotoCard extends Struct.ComponentSchema {
  collectionName: 'components_cards_photo_cards';
  info: {
    displayName: 'Photo_Card';
  };
  attributes: {
    date: Schema.Attribute.Date;
    image: Schema.Attribute.Media<'images' | 'files', true> &
      Schema.Attribute.Required;
    isFeatured: Schema.Attribute.Boolean &
      Schema.Attribute.Required &
      Schema.Attribute.DefaultTo<false>;
    title: Schema.Attribute.String;
  };
}

export interface CardsPlayerCard extends Struct.ComponentSchema {
  collectionName: 'components_cards_player_cards';
  info: {
    displayName: 'Player_Card';
  };
  attributes: {
    desc: Schema.Attribute.String;
    dob: Schema.Attribute.Date;
    height: Schema.Attribute.String;
    image: Schema.Attribute.Text;
    level: Schema.Attribute.String;
    name: Schema.Attribute.String;
    position: Schema.Attribute.String;
    ratings: Schema.Attribute.String;
    role: Schema.Attribute.String;
    total_matches: Schema.Attribute.String;
    trophy: Schema.Attribute.String;
    weight: Schema.Attribute.String;
  };
}

export interface CardsRayCard extends Struct.ComponentSchema {
  collectionName: 'components_cards_ray_cards';
  info: {
    description: '';
    displayName: 'Ray_Card';
    icon: 'dashboard';
  };
  attributes: {
    after_ray_items: Schema.Attribute.Component<'items.ray-items', false>;
    before_ray_items: Schema.Attribute.Component<'items.ray-items', false>;
    description: Schema.Attribute.String;
    span: Schema.Attribute.Enumeration<['one', 'two', 'three']>;
    title: Schema.Attribute.String;
  };
}

export interface CardsSocialMediaCard extends Struct.ComponentSchema {
  collectionName: 'components_cards_social_media_cards';
  info: {
    description: '';
    displayName: 'Social_Media_Card';
    icon: 'dashboard';
  };
  attributes: {
    Description: Schema.Attribute.String;
    span: Schema.Attribute.Enumeration<['one', 'two', 'three']>;
    Title: Schema.Attribute.String;
  };
}

export interface DynamicZoneBrands extends Struct.ComponentSchema {
  collectionName: 'components_dynamic_zone_brands';
  info: {
    description: '';
    displayName: 'Brands';
    icon: 'bulletList';
  };
  attributes: {
    heading: Schema.Attribute.String;
    sub_heading: Schema.Attribute.String;
  };
}

export interface DynamicZoneCalender extends Struct.ComponentSchema {
  collectionName: 'components_dynamic_zone_calenders';
  info: {
    displayName: 'Calender';
  };
  attributes: {
    calender_card: Schema.Attribute.Component<'shared.calender-card', true>;
  };
}

export interface DynamicZoneCard extends Struct.ComponentSchema {
  collectionName: 'components_dynamic_zone_cards';
  info: {
    displayName: 'Card';
  };
  attributes: {
    data: Schema.Attribute.Component<'items.cardi-item', true>;
  };
}

export interface DynamicZoneCarousel extends Struct.ComponentSchema {
  collectionName: 'components_dynamic_zone_carousels';
  info: {
    displayName: 'Carousel';
  };
  attributes: {
    heading: Schema.Attribute.String;
    image: Schema.Attribute.Media<'images' | 'files' | 'videos' | 'audios'>;
    sub_heading: Schema.Attribute.String;
  };
}

export interface DynamicZoneContact extends Struct.ComponentSchema {
  collectionName: 'components_dynamic_zone_contacts';
  info: {
    description: '';
    displayName: 'Contact';
  };
  attributes: {
    backgroundImage: Schema.Attribute.Media<'images'>;
    contact_info: Schema.Attribute.Component<'shared.contact-info', true>;
    formInputs: Schema.Attribute.Component<'items.input', true>;
    heading: Schema.Attribute.String;
    image: Schema.Attribute.Media<'images'>;
    location: Schema.Attribute.String;
    socials: Schema.Attribute.Component<'shared.social-item', true>;
    sub_heading: Schema.Attribute.String;
  };
}

export interface DynamicZoneCta extends Struct.ComponentSchema {
  collectionName: 'components_dynamic_zone_ctas';
  info: {
    description: '';
    displayName: 'CTA';
    icon: 'cursor';
  };
  attributes: {
    CTAs: Schema.Attribute.Component<'shared.button', true>;
    heading: Schema.Attribute.String;
    sub_heading: Schema.Attribute.String;
  };
}

export interface DynamicZoneFaq extends Struct.ComponentSchema {
  collectionName: 'components_dynamic_zone_faqs';
  info: {
    description: '';
    displayName: 'FAQ';
    icon: 'question';
  };
  attributes: {
    backgroundImage: Schema.Attribute.Media<'images'>;
    data: Schema.Attribute.Component<'items.faq-item', true>;
    foregroundImage: Schema.Attribute.Media<'files' | 'videos' | 'audios'>;
    heading: Schema.Attribute.String;
    sub_heading: Schema.Attribute.String;
  };
}

export interface DynamicZoneFeatures extends Struct.ComponentSchema {
  collectionName: 'components_dynamic_zone_features';
  info: {
    description: '';
    displayName: 'Features';
    icon: 'bulletList';
  };
  attributes: {
    globe_card: Schema.Attribute.Component<'cards.globe-card', false>;
    graph_card: Schema.Attribute.Component<'cards.graph-card', false>;
    heading: Schema.Attribute.String;
    ray_card: Schema.Attribute.Component<'cards.ray-card', false>;
    social_media_card: Schema.Attribute.Component<
      'cards.social-media-card',
      false
    >;
    sub_heading: Schema.Attribute.String;
  };
}

export interface DynamicZoneFormNextToSection extends Struct.ComponentSchema {
  collectionName: 'components_dynamic_zone_form_next_to_sections';
  info: {
    description: '';
    displayName: 'Form_Next_To_Section';
    icon: 'book';
  };
  attributes: {
    form: Schema.Attribute.Component<'shared.form', false>;
    heading: Schema.Attribute.String;
    section: Schema.Attribute.Component<'shared.section', false>;
    social_media_icon_links: Schema.Attribute.Component<
      'shared.social-media-icon-links',
      true
    >;
    sub_heading: Schema.Attribute.String;
  };
}

export interface DynamicZoneHero extends Struct.ComponentSchema {
  collectionName: 'components_dynamic_zone_heroes';
  info: {
    description: '';
    displayName: 'Hero';
    icon: 'layout';
  };
  attributes: {
    background: Schema.Attribute.Component<'shared.background', false>;
    heading: Schema.Attribute.String;
    hero_image: Schema.Attribute.Media<'images'>;
    primary_buttons: Schema.Attribute.Component<'shared.button', false>;
    secondary_buttons: Schema.Attribute.Component<'shared.button', false>;
    sub_heading: Schema.Attribute.String;
  };
}

export interface DynamicZoneHowItWorks extends Struct.ComponentSchema {
  collectionName: 'components_dynamic_zone_how_it_works';
  info: {
    description: '';
    displayName: 'How_It_Works';
    icon: 'question';
  };
  attributes: {
    heading: Schema.Attribute.String;
    steps: Schema.Attribute.Component<'shared.steps', true>;
    sub_heading: Schema.Attribute.String;
  };
}

export interface DynamicZoneLaunches extends Struct.ComponentSchema {
  collectionName: 'components_dynamic_zone_launches';
  info: {
    description: '';
    displayName: 'Launches';
    icon: 'rocket';
  };
  attributes: {
    heading: Schema.Attribute.String;
    launches: Schema.Attribute.Component<'shared.launches', true>;
    sub_heading: Schema.Attribute.String;
  };
}

export interface DynamicZonePartner extends Struct.ComponentSchema {
  collectionName: 'components_dynamic_zone_partners';
  info: {
    displayName: 'Partner';
    icon: 'gate';
  };
  attributes: {
    heading: Schema.Attribute.String;
    partnerData: Schema.Attribute.Component<'items.partner-item', true>;
    sub_heading: Schema.Attribute.String;
  };
}

export interface DynamicZonePricing extends Struct.ComponentSchema {
  collectionName: 'components_dynamic_zone_pricings';
  info: {
    description: '';
    displayName: 'Pricing';
    icon: 'shoppingCart';
  };
  attributes: {
    backgroundImage: Schema.Attribute.Media<'images'>;
    heading: Schema.Attribute.String;
    plans: Schema.Attribute.Component<'items.pricing-item', true>;
    sub_heading: Schema.Attribute.String;
  };
}

export interface DynamicZoneTestimonials extends Struct.ComponentSchema {
  collectionName: 'components_dynamic_zone_testimonials';
  info: {
    description: '';
    displayName: 'Testimonials';
    icon: 'emotionHappy';
  };
  attributes: {
    backgroundImage: Schema.Attribute.Media<'images'>;
    data: Schema.Attribute.Component<'shared.testimonial-items', true>;
    heading: Schema.Attribute.String;
    sub_heading: Schema.Attribute.String;
  };
}

export interface GlobalFooter extends Struct.ComponentSchema {
  collectionName: 'components_global_footers';
  info: {
    description: '';
    displayName: 'Footer';
    icon: 'apps';
  };
  attributes: {
    about: Schema.Attribute.Component<'shared.about', false>;
    contact: Schema.Attribute.Component<'shared.contact', true>;
    copyright: Schema.Attribute.String;
    legals: Schema.Attribute.Component<'shared.legals', true>;
    logopart: Schema.Attribute.Component<'shared.logopart', false>;
    posts: Schema.Attribute.Component<'shared.posts', true>;
    services: Schema.Attribute.Component<'shared.services', true>;
    shortLinks: Schema.Attribute.Component<'shared.link', true>;
    socials: Schema.Attribute.Component<'shared.social-media-icon-links', true>;
  };
}

export interface GlobalNavbar extends Struct.ComponentSchema {
  collectionName: 'components_global_navbars';
  info: {
    description: '';
    displayName: 'Navbar';
    icon: 'bold';
  };
  attributes: {
    buttons: Schema.Attribute.Component<'shared.button', true>;
    contacts: Schema.Attribute.Component<'shared.contact-details', false>;
    logo: Schema.Attribute.Component<'shared.logo', false>;
    nav_links: Schema.Attribute.Component<'shared.nav-links', true>;
    socials: Schema.Attribute.Component<'items.icon', true>;
  };
}

export interface ItemsCardiItem extends Struct.ComponentSchema {
  collectionName: 'components_items_card_items';
  info: {
    description: '';
    displayName: 'Card_Item';
    icon: 'chartBubble';
  };
  attributes: {
    badges: Schema.Attribute.JSON;
    buttons: Schema.Attribute.Component<'shared.button', true>;
    date: Schema.Attribute.Date;
    description: Schema.Attribute.Text;
    designation: Schema.Attribute.String;
    discount: Schema.Attribute.String;
    icon: Schema.Attribute.Media<'images'>;
    image: Schema.Attribute.Media<'images'>;
    isFavourite: Schema.Attribute.Boolean;
    isFeatured: Schema.Attribute.Boolean;
    isShared: Schema.Attribute.Boolean;
    name: Schema.Attribute.String;
    price: Schema.Attribute.String;
    ratings: Schema.Attribute.Float;
    stat: Schema.Attribute.Enumeration<
      ['active', 'inactive', 'available', 'out_of_stock', 'coming_soon']
    > &
      Schema.Attribute.DefaultTo<'inactive'>;
    tags: Schema.Attribute.JSON;
    title: Schema.Attribute.String;
    video: Schema.Attribute.Media<'videos'>;
  };
}

export interface ItemsFaqItem extends Struct.ComponentSchema {
  collectionName: 'components_items_faq_items';
  info: {
    displayName: 'Faq_Item';
  };
  attributes: {
    answer: Schema.Attribute.Text;
    isOpen: Schema.Attribute.Boolean;
    question: Schema.Attribute.String;
  };
}

export interface ItemsGraphCardTopItems extends Struct.ComponentSchema {
  collectionName: 'components_items_graph_card_top_items';
  info: {
    displayName: 'Graph_Card_Top_Items';
    icon: 'bulletList';
  };
  attributes: {
    number: Schema.Attribute.String;
    text: Schema.Attribute.String;
  };
}

export interface ItemsIcon extends Struct.ComponentSchema {
  collectionName: 'components_items_icons';
  info: {
    description: '';
    displayName: 'icon';
  };
  attributes: {
    href: Schema.Attribute.String;
    icon: Schema.Attribute.Media<'images' | 'files' | 'videos' | 'audios'>;
  };
}

export interface ItemsInput extends Struct.ComponentSchema {
  collectionName: 'components_items_inputs';
  info: {
    description: '';
    displayName: 'Input';
    icon: 'apps';
  };
  attributes: {
    name: Schema.Attribute.String;
    placeholder: Schema.Attribute.String;
    required: Schema.Attribute.Boolean & Schema.Attribute.DefaultTo<false>;
    type: Schema.Attribute.Enumeration<
      [
        'text',
        'email',
        'password',
        'submit',
        'textarea',
        'button',
        'checkbox',
        'color',
        'date',
        'datetime-local',
        'file',
        'hidden',
        'image',
        'month',
        'number',
        'radio',
        'range',
        'reset',
        'search',
        'tel',
        'time',
        'url',
        'week',
      ]
    > &
      Schema.Attribute.DefaultTo<'text'>;
  };
}

export interface ItemsLeftNavbarItems extends Struct.ComponentSchema {
  collectionName: 'components_items_left_navbar_items';
  info: {
    displayName: 'Left_Navbar_Items';
    icon: 'bulletList';
  };
  attributes: {
    name: Schema.Attribute.String;
    URL: Schema.Attribute.String;
  };
}

export interface ItemsPartnerItem extends Struct.ComponentSchema {
  collectionName: 'components_items_partner_items';
  info: {
    displayName: 'Partner_Item';
    icon: 'expand';
  };
  attributes: {
    description: Schema.Attribute.Text;
    link: Schema.Attribute.String;
    logo: Schema.Attribute.Media<'images'>;
    name: Schema.Attribute.String;
  };
}

export interface ItemsPricingItem extends Struct.ComponentSchema {
  collectionName: 'components_items_pricing_items';
  info: {
    displayName: 'Pricing_Item';
    icon: 'sun';
  };
  attributes: {
    button: Schema.Attribute.Component<'shared.button', false>;
    currency: Schema.Attribute.String;
    description: Schema.Attribute.Text;
    features: Schema.Attribute.Component<'shared.features', true>;
    featureTitle: Schema.Attribute.String;
    isFeatured: Schema.Attribute.Boolean & Schema.Attribute.DefaultTo<false>;
    name: Schema.Attribute.String;
    price: Schema.Attribute.String;
    tags: Schema.Attribute.JSON;
    type: Schema.Attribute.Enumeration<['Monthly', 'Annually']>;
  };
}

export interface ItemsRayItems extends Struct.ComponentSchema {
  collectionName: 'components_items_ray_items';
  info: {
    description: '';
    displayName: 'Ray_Card_Items';
    icon: 'bulletList';
  };
  attributes: {
    item_1: Schema.Attribute.String;
    item_2: Schema.Attribute.String;
    item_3: Schema.Attribute.String;
  };
}

export interface SharedAbout extends Struct.ComponentSchema {
  collectionName: 'components_shared_abouts';
  info: {
    displayName: 'About';
  };
  attributes: {
    desc: Schema.Attribute.String;
    image: Schema.Attribute.Media<'images' | 'files' | 'videos' | 'audios'>;
  };
}

export interface SharedBackground extends Struct.ComponentSchema {
  collectionName: 'components_shared_backgrounds';
  info: {
    description: '';
    displayName: 'background';
  };
  attributes: {
    bg_image: Schema.Attribute.Media<'images' | 'files'>;
    bg_video: Schema.Attribute.Media<'files' | 'videos', true>;
  };
}

export interface SharedButton extends Struct.ComponentSchema {
  collectionName: 'components_shared_buttons';
  info: {
    description: '';
    displayName: 'Button';
    icon: 'cursor';
  };
  attributes: {
    icons: Schema.Attribute.Media<'images' | 'files' | 'videos' | 'audios'>;
    label: Schema.Attribute.String;
    path: Schema.Attribute.String;
    size: Schema.Attribute.Enumeration<['default', 'sm', 'lg', 'icon']>;
    target: Schema.Attribute.String;
    title: Schema.Attribute.String;
    variant: Schema.Attribute.Enumeration<
      ['default', 'secondary', 'outline', 'ghost', 'link', 'destructive']
    >;
  };
}

export interface SharedCalenderCard extends Struct.ComponentSchema {
  collectionName: 'components_shared_calender_cards';
  info: {
    displayName: 'CalenderCard';
    icon: 'chartBubble';
  };
  attributes: {
    date: Schema.Attribute.Date;
    desc: Schema.Attribute.String;
    image: Schema.Attribute.Media<'images' | 'files' | 'videos' | 'audios'>;
    title: Schema.Attribute.String;
    type: Schema.Attribute.String;
  };
}

export interface SharedContact extends Struct.ComponentSchema {
  collectionName: 'components_shared_contacts';
  info: {
    displayName: 'Contact';
    icon: 'phone';
  };
  attributes: {
    icon: Schema.Attribute.Media<'images' | 'files' | 'videos' | 'audios'>;
    name: Schema.Attribute.String;
  };
}

export interface SharedContactDetails extends Struct.ComponentSchema {
  collectionName: 'components_shared_contact_details';
  info: {
    displayName: 'Contact_Details';
  };
  attributes: {
    email: Schema.Attribute.String;
    phone: Schema.Attribute.String;
  };
}

export interface SharedContactInfo extends Struct.ComponentSchema {
  collectionName: 'components_shared_contact_infos';
  info: {
    displayName: 'Contact_Info';
  };
  attributes: {
    image: Schema.Attribute.Media<'images'>;
    info: Schema.Attribute.String;
  };
}

export interface SharedFeatures extends Struct.ComponentSchema {
  collectionName: 'components_shared_features';
  info: {
    displayName: 'features';
    icon: 'feather';
  };
  attributes: {
    included: Schema.Attribute.Boolean;
    title: Schema.Attribute.String;
  };
}

export interface SharedForm extends Struct.ComponentSchema {
  collectionName: 'components_shared_forms';
  info: {
    description: '';
    displayName: 'Form';
    icon: 'paperPlane';
  };
  attributes: {
    inputs: Schema.Attribute.Component<'items.input', true>;
  };
}

export interface SharedIcon extends Struct.ComponentSchema {
  collectionName: 'components_shared_icons';
  info: {
    description: '';
    displayName: 'icon';
    icon: 'puzzle';
  };
  attributes: {};
}

export interface SharedLaunches extends Struct.ComponentSchema {
  collectionName: 'components_shared_launches';
  info: {
    description: '';
    displayName: 'Launches';
    icon: 'rocket';
  };
  attributes: {
    description: Schema.Attribute.String;
    mission_number: Schema.Attribute.String;
    title: Schema.Attribute.String;
  };
}

export interface SharedLegals extends Struct.ComponentSchema {
  collectionName: 'components_shared_legals';
  info: {
    displayName: 'legals';
  };
  attributes: {
    label: Schema.Attribute.String;
    path: Schema.Attribute.String;
  };
}

export interface SharedLink extends Struct.ComponentSchema {
  collectionName: 'components_shared_links';
  info: {
    description: '';
    displayName: 'Link';
    icon: 'link';
  };
  attributes: {
    href: Schema.Attribute.String;
    target: Schema.Attribute.Enumeration<
      ['_blank', '_self', '_parent', '_top']
    >;
    title: Schema.Attribute.String;
  };
}

export interface SharedLinkWithUrlTarget extends Struct.ComponentSchema {
  collectionName: 'components_shared_link_with_url_targets';
  info: {
    displayName: 'Link_With_Url_Target';
    icon: 'folder';
  };
  attributes: {
    target: Schema.Attribute.String;
    url: Schema.Attribute.String;
  };
}

export interface SharedLogo extends Struct.ComponentSchema {
  collectionName: 'components_shared_logos';
  info: {
    displayName: 'logo';
  };
  attributes: {
    description: Schema.Attribute.String;
    image: Schema.Attribute.Media<'images'>;
    name: Schema.Attribute.String;
  };
}

export interface SharedLogopart extends Struct.ComponentSchema {
  collectionName: 'components_shared_logoparts';
  info: {
    displayName: 'logopart';
    icon: 'filePdf';
  };
  attributes: {
    desc: Schema.Attribute.Text;
    image: Schema.Attribute.Media<'images'>;
    website: Schema.Attribute.String;
  };
}

export interface SharedNavLinks extends Struct.ComponentSchema {
  collectionName: 'components_shared_nav_links';
  info: {
    displayName: 'nav_links';
  };
  attributes: {
    links: Schema.Attribute.Component<'shared.link', false>;
    sub_links: Schema.Attribute.Component<'shared.link', true>;
  };
}

export interface SharedNewsCard extends Struct.ComponentSchema {
  collectionName: 'components_shared_news_cards';
  info: {
    displayName: 'News_Card';
  };
  attributes: {
    date: Schema.Attribute.Date;
    desc: Schema.Attribute.String;
    image: Schema.Attribute.Media<'images' | 'files' | 'videos' | 'audios'>;
    isFeatured: Schema.Attribute.Boolean;
    tags: Schema.Attribute.Component<'shared.tags', true>;
    title: Schema.Attribute.String;
  };
}

export interface SharedPerks extends Struct.ComponentSchema {
  collectionName: 'components_shared_perks';
  info: {
    description: '';
    displayName: 'Perks';
    icon: 'check';
  };
  attributes: {
    text: Schema.Attribute.String;
  };
}

export interface SharedPosts extends Struct.ComponentSchema {
  collectionName: 'components_shared_posts';
  info: {
    displayName: 'posts';
  };
  attributes: {
    date: Schema.Attribute.Date;
    href: Schema.Attribute.String;
    image: Schema.Attribute.Media<'images'>;
    title: Schema.Attribute.String;
  };
}

export interface SharedSection extends Struct.ComponentSchema {
  collectionName: 'components_shared_sections';
  info: {
    displayName: 'Section';
    icon: 'cursor';
  };
  attributes: {
    heading: Schema.Attribute.String;
    sub_heading: Schema.Attribute.String;
    users: Schema.Attribute.Component<'shared.user', true>;
  };
}

export interface SharedSeo extends Struct.ComponentSchema {
  collectionName: 'components_shared_seos';
  info: {
    description: '';
    displayName: 'seo';
    icon: 'search';
  };
  attributes: {
    canonicalURL: Schema.Attribute.String;
    keywords: Schema.Attribute.Text;
    metaDescription: Schema.Attribute.Text;
    metaImage: Schema.Attribute.Media<'images' | 'files' | 'videos'>;
    metaRobots: Schema.Attribute.String;
    metaTitle: Schema.Attribute.String;
    metaViewport: Schema.Attribute.String;
    structuredData: Schema.Attribute.JSON;
  };
}

export interface SharedServices extends Struct.ComponentSchema {
  collectionName: 'components_shared_services';
  info: {
    displayName: 'services';
  };
  attributes: {
    href: Schema.Attribute.String;
    title: Schema.Attribute.String;
  };
}

export interface SharedSocialItem extends Struct.ComponentSchema {
  collectionName: 'components_shared_social_items';
  info: {
    displayName: 'Social_Item';
    icon: 'gift';
  };
  attributes: {
    image: Schema.Attribute.Media<'images'>;
    link: Schema.Attribute.Component<'shared.link-with-url-target', false>;
  };
}

export interface SharedSocialMediaIconLinks extends Struct.ComponentSchema {
  collectionName: 'components_shared_social_media_icon_links';
  info: {
    description: '';
    displayName: 'Social_Media_Icon_Links';
    icon: 'expand';
  };
  attributes: {
    image: Schema.Attribute.Media<'images' | 'files' | 'videos' | 'audios'>;
    link: Schema.Attribute.Component<'shared.link', false>;
  };
}

export interface SharedSteps extends Struct.ComponentSchema {
  collectionName: 'components_shared_steps';
  info: {
    description: '';
    displayName: 'Steps';
    icon: 'bulletList';
  };
  attributes: {
    description: Schema.Attribute.String;
    title: Schema.Attribute.String;
  };
}

export interface SharedSubLinks extends Struct.ComponentSchema {
  collectionName: 'components_shared_sub_links';
  info: {
    displayName: 'sub_links';
  };
  attributes: {
    href: Schema.Attribute.String;
    title: Schema.Attribute.String;
  };
}

export interface SharedTags extends Struct.ComponentSchema {
  collectionName: 'components_shared_tags';
  info: {
    displayName: 'Tags';
  };
  attributes: {
    tags: Schema.Attribute.String;
  };
}

export interface SharedTestimonialItems extends Struct.ComponentSchema {
  collectionName: 'components_shared_testimonial_items';
  info: {
    displayName: 'TestimonialItems';
    icon: 'gift';
  };
  attributes: {
    author: Schema.Attribute.String;
    avatar: Schema.Attribute.Media<'images'>;
    company: Schema.Attribute.String;
    content: Schema.Attribute.Text;
    date: Schema.Attribute.Date;
    designation: Schema.Attribute.String;
    location: Schema.Attribute.String;
    rating: Schema.Attribute.Float;
  };
}

export interface SharedUser extends Struct.ComponentSchema {
  collectionName: 'components_shared_users';
  info: {
    description: '';
    displayName: 'User';
    icon: 'user';
  };
  attributes: {
    firstname: Schema.Attribute.String;
    image: Schema.Attribute.Media<'images'>;
    job: Schema.Attribute.String;
    lastname: Schema.Attribute.String;
  };
}

declare module '@strapi/strapi' {
  export module Public {
    export interface ComponentSchemas {
      'cards.globe-card': CardsGlobeCard;
      'cards.graph-card': CardsGraphCard;
      'cards.member-card': CardsMemberCard;
      'cards.photo-card': CardsPhotoCard;
      'cards.player-card': CardsPlayerCard;
      'cards.ray-card': CardsRayCard;
      'cards.social-media-card': CardsSocialMediaCard;
      'dynamic-zone.brands': DynamicZoneBrands;
      'dynamic-zone.calender': DynamicZoneCalender;
      'dynamic-zone.card': DynamicZoneCard;
      'dynamic-zone.carousel': DynamicZoneCarousel;
      'dynamic-zone.contact': DynamicZoneContact;
      'dynamic-zone.cta': DynamicZoneCta;
      'dynamic-zone.faq': DynamicZoneFaq;
      'dynamic-zone.features': DynamicZoneFeatures;
      'dynamic-zone.form-next-to-section': DynamicZoneFormNextToSection;
      'dynamic-zone.hero': DynamicZoneHero;
      'dynamic-zone.how-it-works': DynamicZoneHowItWorks;
      'dynamic-zone.launches': DynamicZoneLaunches;
      'dynamic-zone.partner': DynamicZonePartner;
      'dynamic-zone.pricing': DynamicZonePricing;
      'dynamic-zone.testimonials': DynamicZoneTestimonials;
      'global.footer': GlobalFooter;
      'global.navbar': GlobalNavbar;
      'items.cardi-item': ItemsCardiItem;
      'items.faq-item': ItemsFaqItem;
      'items.graph-card-top-items': ItemsGraphCardTopItems;
      'items.icon': ItemsIcon;
      'items.input': ItemsInput;
      'items.left-navbar-items': ItemsLeftNavbarItems;
      'items.partner-item': ItemsPartnerItem;
      'items.pricing-item': ItemsPricingItem;
      'items.ray-items': ItemsRayItems;
      'shared.about': SharedAbout;
      'shared.background': SharedBackground;
      'shared.button': SharedButton;
      'shared.calender-card': SharedCalenderCard;
      'shared.contact': SharedContact;
      'shared.contact-details': SharedContactDetails;
      'shared.contact-info': SharedContactInfo;
      'shared.features': SharedFeatures;
      'shared.form': SharedForm;
      'shared.icon': SharedIcon;
      'shared.launches': SharedLaunches;
      'shared.legals': SharedLegals;
      'shared.link': SharedLink;
      'shared.link-with-url-target': SharedLinkWithUrlTarget;
      'shared.logo': SharedLogo;
      'shared.logopart': SharedLogopart;
      'shared.nav-links': SharedNavLinks;
      'shared.news-card': SharedNewsCard;
      'shared.perks': SharedPerks;
      'shared.posts': SharedPosts;
      'shared.section': SharedSection;
      'shared.seo': SharedSeo;
      'shared.services': SharedServices;
      'shared.social-item': SharedSocialItem;
      'shared.social-media-icon-links': SharedSocialMediaIconLinks;
      'shared.steps': SharedSteps;
      'shared.sub-links': SharedSubLinks;
      'shared.tags': SharedTags;
      'shared.testimonial-items': SharedTestimonialItems;
      'shared.user': SharedUser;
    }
  }
}
