const pluralize = require("pluralize");
const { getCleanVariableNameWithUnderscore } = require("./utils");
const { slugify } = require("./slugify");

function mapDynamicZoneComponents(obj, mapping) {
  if (Array.isArray(obj)) {
    return obj.map((item) => mapDynamicZoneComponents(item, mapping));
  }

  if (!obj || typeof obj !== "object") {
    return obj;
  }

  const result = {};

  for (const [key, value] of Object.entries(obj)) {
    if (key === "__component" && value?.startsWith("dynamic-zone.")) {
      const zoneKey = value.split(".")[1];
      const mappedKeys = mapping[zoneKey];
      const xsiteMeta = slugify(obj.xsite_meta);

      if (
        xsiteMeta &&
        xsiteMeta !== "undefined" &&
        Array.isArray(mappedKeys) &&
        mappedKeys.length > 0
      ) {
        result["__component"] = `dynamic-zone.${xsiteMeta}`;

        const newKey = pluralize(getCleanVariableNameWithUnderscore(xsiteMeta));

        for (const [fieldKey, fieldValue] of Object.entries(obj)) {
          if (["__component", "xsite_meta"].includes(fieldKey)) continue;

          if (mappedKeys.includes(fieldKey)) {
            result[newKey] = mapDynamicZoneComponents(fieldValue, mapping);
          } else {
            result[fieldKey] = mapDynamicZoneComponents(fieldValue, mapping);
          }
        }
        return result;
      } else {
        result[key] = value;
        continue;
      }
    }
    result[key] = mapDynamicZoneComponents(value, mapping);
  }

  return result;
}

module.exports = {
  mapDynamicZoneComponents,
};
