import React from "react";
import dynamic from "next/dynamic";
import installedComponents from "../../installedComponents.json";

interface DynamicZoneComponent {
  __component: string;
  id: number;
  [key: string]: any;
}

interface Props {
  dynamicZone: DynamicZoneComponent[];
  locale: string;
  dynamicComponent?: React.ReactNode;
}

//dynamic import of components
const dynamicImport = (slug: string) => {
  return dynamic(() => import(`../${slug}`).then((mod) => mod.default), {
    ssr: false,
  });
};

//mapping of components
const componentMapping: { [key: string]: any } = installedComponents.reduce<{
  [key: string]: any;
}>((mapping, comp) => {
  mapping[`dynamic-zone.${comp.slug}`] = dynamicImport(comp.slug);
  return mapping;
}, {});

const DynamicZoneManager: React.FC<Props> = ({
  dynamicZone,
  locale,
  dynamicComponent,
}) => {
  return (
    <div>
      {dynamicZone.map((componentData) => {
        if (
          componentData.__component ===
          "dynamic-zone.replaceable-dynamic-content"
        ) {
          console.log("Replaceable Dynamic Content Component", componentData);
          return <div key={componentData.id}>{dynamicComponent}</div>;
        }

        const Component = componentMapping[componentData.__component];

        if (!Component) {
          console.warn(`No component found for: ${componentData.__component}`);
          return null;
        }

        console.log("Dynamic Zone Component Data", componentData);

        return (
          <Component
            key={componentData.id}
            {...componentData}
            locale={locale}
          />
        );
      })}
    </div>
  );
};

export default DynamicZoneManager;
